<?php
require '../config.php';

// Script untuk otomatis menyelesaikan pesanan yang status 'dikirim' selama 15 hari
$query = "
UPDATE transaksi 
SET status = 'selesai', tanggal_selesai = NOW() 
WHERE status = 'dikirim' 
AND DATEDIFF(NOW(), diubah_pada) >= 15
AND tanggal_selesai IS NULL
";

$result = mysqli_query($conn, $query);

if ($result) {
    $affected_rows = mysqli_affected_rows($conn);
    echo "Auto-complete: $affected_rows pesanan telah otomatis diselesaikan.\n";

    // Log ke file untuk monitoring
    $log_message = date('Y-m-d H:i:s') . " - Auto-complete: $affected_rows pesanan diselesaikan\n";
    error_log($log_message, 3, '../logs/auto_complete.log');
} else {
    echo "Error: " . mysqli_error($conn) . "\n";
    error_log(date('Y-m-d H:i:s') . " - Error auto-complete: " . mysqli_error($conn) . "\n", 3, '../logs/auto_complete.log');
}

$conn->close();
