<?php
require_once __DIR__ . '/../config.php';

// Script untuk auto-cancel pesanan yang tidak dibayar dalam 5 menit
function autoCancelUnpaidOrders()
{
    global $conn;

    // Ambil pesanan yang statusnya 'menunggu' dan sudah lewat 5 menit
    $query = "
        UPDATE transaksi 
        SET status = 'dibatalkan' 
        WHERE status = 'menunggu' 
        AND TIMESTAMPDIFF(MINUTE, dibuat_pada, NOW()) >= 5
        AND bukti_pembayaran IS NULL
    ";

    $result = mysqli_query($conn, $query);

    if ($result) {
        $affected_rows = mysqli_affected_rows($conn);
        if ($affected_rows > 0) {
            echo "Auto-cancelled $affected_rows orders due to timeout.\n";

            // Kembalikan stok untuk pesanan yang dibatalkan
            $restore_stock_query = "
                UPDATE ukuran_produk up
                INNER JOIN transaksi_detail td ON up.id = td.ukuran_id
                INNER JOIN transaksi t ON td.transaksi_id = t.id
                SET up.stok = up.stok + td.jumlah
                WHERE t.status = 'dibatalkan' 
                AND t.dibuat_pada >= DATE_SUB(NOW(), INTERVAL 6 MINUTE)
            ";

            mysqli_query($conn, $restore_stock_query);
            echo "Stock restored for cancelled orders.\n";
        }
    }
}

// Jalankan fungsi auto-cancel
autoCancelUnpaidOrders();
