<?php
session_start();
require '../config.php'; // Ubah sesuai path config database-mu
require '../pelanggan/navbar.php';

// Cek login
if (!isset($_SESSION['user_id']) || $_SESSION['peran'] != 'pelanggan') {
    header("Location: ../login/pelanggan_login.php");
    exit;
}

// Ambil nama pelanggan
$nama_pelanggan = $_SESSION['nama'];
$pelanggan_id = $_SESSION['user_id'];

// Hitung jumlah status pesanan
$status_list = ['menunggu', 'dibayar', 'dikirim', 'selesai', 'dibatalkan'];
$status_counts = [];

foreach ($status_list as $status) {
    $stmt = $conn->prepare("SELECT COUNT(*) as jumlah FROM transaksi WHERE pengguna_id = ? AND status = ?");
    $stmt->bind_param("is", $pelanggan_id, $status);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $status_counts[$status] = $result['jumlah'];
}

// Status colors and icons
$status_config = [
    'menunggu' => ['color' => 'warning', 'icon' => 'clock', 'text' => 'Menunggu Konfirmasi'],
    'dibayar' => ['color' => 'success', 'icon' => 'check-circle', 'text' => 'Sudah Dibayar'],
    'dikirim' => ['color' => 'info', 'icon' => 'truck', 'text' => 'Sedang Dikirim'],
    'selesai' => ['color' => 'primary', 'icon' => 'check-double', 'text' => 'Pesanan Selesai'],
    'dibatalkan' => ['color' => 'danger', 'icon' => 'times-circle', 'text' => 'Dibatalkan']
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard - Day Apparel</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
  
  <!-- Welcome Section -->
  <div class="row mb-4">
    <div class="col-12">
      <div class="card border-0 shadow-sm">
        <div class="card-body text-black p-4">
          <div class="row align-items-center">
            <div class="col-md-8">
              <h3 class="fw-bold mb-2">
                <i class="fas fa-home me-2"></i>
                Selamat datang kembali, <?= htmlspecialchars($nama_pelanggan) ?>!
              </h3>
              <p class="mb-0 opacity-75">
                Kelola pesanan Anda dan jelajahi koleksi fashion terbaru kami
              </p>
            </div>
            <div class="col-md-4 text-end">
              <div class="d-none d-md-block">
                <i class="fas fa-shopping-bag fa-3x opacity-25"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Quick Actions -->
  <div class="row mb-4">
    <div class="col-12">
      <div class="card border-0 shadow-sm">
        <div class="card-body p-4">
          <h5 class="fw-bold text-dark mb-3">
            <i class="fas fa-bolt me-2 text-primary"></i>
            Aksi Cepat
          </h5>
          <div class="row g-2">
            <div class="col-6 col-md-3">
              <a href="/day.apparel/index.php" class="btn btn-outline-primary w-100 py-2">
                <i class="fas fa-store me-2"></i>
                <span class="d-none d-sm-inline">Lihat </span>Katalog
              </a>
            </div>
            <div class="col-6 col-md-3">
              <a href="riwayat.php" class="btn btn-outline-secondary w-100 py-2">
                <i class="fas fa-history me-2"></i>
                <span class="d-none d-sm-inline">Riwayat </span>Pesanan
              </a>
            </div>
            <div class="col-6 col-md-3">
              <a href="profile.php" class="btn btn-outline-info w-100 py-2">
                <i class="fas fa-user-edit me-2"></i>
                <span class="d-none d-sm-inline">Edit </span>Profile
              </a>
            </div>
            <div class="col-6 col-md-3">
              <a href="../logout.php" class="btn btn-outline-danger w-100 py-2" onclick="return confirm('Yakin ingin logout?')">
                <i class="fas fa-sign-out-alt me-2"></i>
                Logout
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Order Status Overview -->
  <div class="row mb-4">
    <div class="col-12">
      <div class="card border-0 shadow-sm">
        <div class="card-body p-4">
          <h5 class="fw-bold text-dark mb-3">
            <i class="fas fa-chart-pie me-2 text-success"></i>
            Status Pemesanan Anda
          </h5>
          <div class="row g-3">
            <?php foreach ($status_list as $status): ?>
              <div class="col-6 col-lg-2-4">
                <div class="card h-100 border-0 shadow-sm hover-card">
                  <div class="card-body text-center p-3">
                    <div class="mb-2">
                      <i class="fas fa-<?= $status_config[$status]['icon'] ?> fa-2x text-<?= $status_config[$status]['color'] ?>"></i>
                    </div>
                    <h6 class="card-title small text-muted mb-1">
                      <?= $status_config[$status]['text'] ?>
                    </h6>
                    <div class="display-6 fw-bold text-<?= $status_config[$status]['color'] ?>">
                      <?= $status_counts[$status] ?>
                    </div>
                    <?php if ($status_counts[$status] > 0): ?>
                      <small class="text-muted">pesanan</small>
                    <?php else: ?>
                      <small class="text-muted">-</small>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Custom Styles -->
<style>
.hover-card {
  transition: transform 0.2s ease-in-out;
}

.hover-card:hover {
  transform: translateY(-5px);
}

.col-lg-2-4 {
  flex: 0 0 auto;
  width: 20%;
}

@media (max-width: 991.98px) {
  .col-lg-2-4 {
    width: 50%;
  }
}

@media (max-width: 575.98px) {
  .col-lg-2-4 {
    width: 100%;
  }
}
</style>

<!-- Custom JavaScript -->
<script>
// Add smooth scrolling for better UX
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener('click', function (e) {
    e.preventDefault();
    document.querySelector(this.getAttribute('href')).scrollIntoView({
      behavior: 'smooth'
    });
  });
});

// Add loading state for external links
document.querySelectorAll('a[href^="/"], a[href^="http"]').forEach(link => {
  link.addEventListener('click', function() {
    // Add loading state if needed
    if (this.classList.contains('btn')) {
      const originalHTML = this.innerHTML;
      this.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Loading...';
      this.disabled = true;
      
      // Reset after 2 seconds in case of issues
      setTimeout(() => {
        this.innerHTML = originalHTML;
        this.disabled = false;
      }, 2000);
    }
  });
});

// Animate counters on page load
window.addEventListener('load', function() {
  const counters = document.querySelectorAll('.display-6');
  counters.forEach(counter => {
    const target = parseInt(counter.textContent);
    const increment = target / 20;
    let current = 0;
    
    const timer = setInterval(() => {
      current += increment;
      if (current >= target) {
        counter.textContent = target;
        clearInterval(timer);
      } else {
        counter.textContent = Math.floor(current);
      }
    }, 50);
  });
});
</script>
  <?php include '../footer.php';?>
</body>
</html>