<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Lupa Password - Day Apparel</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container-fluid vh-100 d-flex align-items-center justify-content-center">
  <div class="row w-100 justify-content-center">
    <div class="col-11 col-sm-8 col-md-6 col-lg-4 col-xl-3">
      
      <!-- Brand Logo/Name -->
      <div class="text-center mb-4">
        <h2 class="fw-bold text-dark mb-1">Day Apparel</h2>
        <p class="text-muted small">Reset password Anda</p>
      </div>

      <!-- Alert Messages -->
      <div id="alert-container">
        <?php if (isset($_GET['pesan'])): ?>
          <div class="alert alert-info alert-dismissible fade show" role="alert">
            <i class="fas fa-info-circle me-2"></i><?= htmlspecialchars($_GET['pesan']) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>
      </div>

      <!-- Forgot Password Card -->
      <div class="card border-0 shadow-sm">
        <div class="card-body p-4">
          
          <!-- Icon and Title -->
          <div class="text-center mb-4">
            <div class="bg-light rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                 style="width: 60px; height: 60px;">
              <i class="fas fa-key text-muted fa-lg"></i>
            </div>
            <h5 class="fw-bold text-dark mb-2">Lupa Password?</h5>
            <p class="text-muted small mb-0">
              Tidak masalah! Masukkan email Anda dan kami akan mengirimkan link untuk reset password.
            </p>
          </div>
          
          <form action="../day.apparel/proses/proses_lupa_password.php" method="POST" id="forgotPasswordForm">
            
            <!-- Email Input -->
            <div class="mb-4">
              <label for="email" class="form-label fw-medium text-dark">Email Anda</label>
              <div class="input-group">
                <span class="input-group-text bg-light border-end-0">
                  <i class="fas fa-envelope text-muted"></i>
                </span>
                <input type="email" 
                       name="email" 
                       id="email"
                       class="form-control border-start-0 ps-0" 
                       placeholder="Masukkan email terdaftar Anda"
                       required>
              </div>
              <div class="form-text text-muted small">
                <i class="fas fa-info-circle me-1"></i>Pastikan email yang Anda masukkan sudah terdaftar
              </div>
            </div>

            <!-- Submit Button -->
            <div class="d-grid mb-3">
              <button type="submit" class="btn btn-dark py-2 fw-medium" id="submitBtn">
                <i class="fas fa-paper-plane me-2"></i>Kirim Link Reset
              </button>
            </div>

          </form>

          <!-- Divider -->
          <div class="text-center mb-3">
            <hr class="my-3">
          </div>

          <!-- Back to Login -->
          <div class="text-center">
            <p class="mb-0">
              <a href="login.php" 
                 class="text-decoration-none fw-medium">
                <i class="fas fa-arrow
                -left me-2"></i>Kembali ke <span class="text-primary">Login</span>
              </a>
            </p>
          </div>

        </div>
      </div>

      <!-- Help Information -->
      <div class="card border-0 mt-3 bg-transparent">
        <div class="card-body text-center p-3">
          <div class="text-muted small">
            <i class="fas fa-question-circle me-2"></i>
            <strong>Butuh bantuan?</strong><br>
            Hubungi customer service kami jika Anda mengalami kesulitan dalam reset password.
          </div>
        </div>
      </div>

      <!-- Footer -->
      <div class="text-center mt-4">
        <p class="text-muted small mb-0">
          © 2025 Day Apparel. All rights reserved.
        </p>
      </div>

    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Custom JavaScript -->
<script>
// Form submission with loading state
document.getElementById('forgotPasswordForm').addEventListener('submit', function(e) {
  const submitBtn = document.getElementById('submitBtn');
  const email = document.getElementById('email').value.trim();
  
  // Basic email validation
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  if (!emailRegex.test(email)) {
    e.preventDefault();
    showMessage('Mohon masukkan format email yang valid!', 'danger');
    return false;
  }
  
  // Show loading state
  submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Mengirim...';
  submitBtn.disabled = true;
  
  // Re-enable button after 3 seconds (in case of error)
  setTimeout(function() {
    submitBtn.innerHTML = '<i class="fas fa-paper-plane me-2"></i>Kirim Link Reset';
    submitBtn.disabled = false;
  }, 3000);
});

// Function to show custom messages
function showMessage(message, type = 'info') {
  const alertContainer = document.getElementById('alert-container');
  const alertHTML = `
    <div class="alert alert-${type} alert-dismissible fade show" role="alert">
      <i class="fas fa-${type === 'danger' ? 'exclamation-circle' : 'info-circle'} me-2"></i>${message}
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  `;
  alertContainer.innerHTML = alertHTML;
  
  // Auto dismiss after 5 seconds
  setTimeout(function() {
    const alert = alertContainer.querySelector('.alert');
    if (alert) {
      const bsAlert = new bootstrap.Alert(alert);
      bsAlert.close();
    }
  }, 5000);
}

// Auto-focus on email input
document.addEventListener('DOMContentLoaded', function() {
  document.getElementById('email').focus();
});

// Enter key submission
document.getElementById('email').addEventListener('keypress', function(e) {
  if (e.key === 'Enter') {
    document.getElementById('forgotPasswordForm').dispatchEvent(new Event('submit'));
  }
});
</script>

</body>
</html>