<?php
require 'config.php';
require '../day.apparel/pelanggan/navbar.php';

// Ambil semua kategori untuk dropdown filter
$kategori_result = mysqli_query($conn, "SELECT * FROM kategori_produk");

// Cek apakah ada filter kategori
$filter_kategori = isset($_GET['kategori']) ? (int)$_GET['kategori'] : 0;

$query = "SELECT produk.*, kategori_produk.nama AS nama_kategori 
          FROM produk 
          JOIN kategori_produk ON produk.kategori_id = kategori_produk.id";

if ($filter_kategori > 0) {
  $query .= " WHERE kategori_id = $filter_kategori";
}

$result = mysqli_query($conn, $query);

// Ambil data diskon untuk semua produk sekaligus (optimasi query)
$diskon_map = [];
$diskon_result = mysqli_query($conn, "SELECT * FROM diskon WHERE aktif = 'ya'");
while ($d = mysqli_fetch_assoc($diskon_result)) {
  $diskon_map[$d['id']] = $d;
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Day Apparel - Koleksi Fashion Terbaru</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>

<body class="bg-light">

  <!-- Hero Carousel -->
  <section class="hero-section">
    <div id="heroCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="4000">
      <div class="carousel-indicators">
        <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="0" class="active"></button>
        <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="1"></button>
        <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="2"></button>
      </div>

      <div class="carousel-inner">
        <div class="carousel-item active">
          <div class="carousel-image-container">
            <!-- Gambar 1 -->
            <img src="/day.apparel/assets/1.png"
              class="d-block w-100 poster-img" alt="Converse Brown">
            <div class="carousel-overlay"></div>
          </div>
          <div class="carousel-caption">
            <div class="container">
              <div class="row justify-content-start">
                <div class="col-md-6">

                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="carousel-item">
          <div class="carousel-image-container">
            <!-- Gambar 2 -->
            <img src="/day.apparel/assets/2.png"
              class="d-block w-100 poster-img" alt="Adidas Blue">
            <div class="carousel-overlay"></div>
          </div>
          <div class="carousel-caption">
            <div class="container">
              <div class="row justify-content-center text-center">
                <div class="col-md-8">

                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="carousel-item">
          <div class="carousel-image-container">
            <!-- Gambar 3 -->
            <img src="/day.apparel/assets/3.png"
              class="d-block w-100 poster-img" alt="Converse Green">
            <div class="carousel-overlay"></div>
          </div>
          <div class="carousel-caption">
            <div class="container">
              <div class="row justify-content-end text-end">
                <div class="col-md-6">

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
        <span class="visually-hidden">Previous</span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
        <span class="visually-hidden">Next</span>
      </button>
    </div>
  </section>

  <!-- Products Section -->
  <section id="products" class="py-5">
    <div class="container">

      <!-- Section Header -->
      <div class="text-center mb-5">
        <h2 class="display-5 fw-bold text-dark mb-3">Koleksi Produk Kami</h2>
        <p class="lead text-muted">Temukan produk fashion berkualitas dengan desain terdepan</p>
        <div class="divider mx-auto"></div>
      </div>

      <!-- Filter Section -->
      <div class="row mb-4 align-items-center">
        <div class="col-12 col-md-auto mb-3 mb-md-0">
          <form method="GET" id="filterForm" class="d-flex align-items-center gap-2">
            <label for="kategori" class="fw-bold me-2 mb-0" style="color:#222;font-size:1.08em;"><i class="fas fa-filter text-primary me-1"></i>Filter Kategori</label>
            <div style="max-width: 100%; overflow-x: auto;">
              <select name="kategori" id="kategori" class="form-select form-select-sm w-100" style="min-width:180px;border-radius:8px;font-size:1em;padding:8px 14px;border:1.5px solid #e0e0e0;background:#f8f9fa;color:#222;font-weight:500;" onchange="this.form.submit()">
              <option value="0">🏷️ Semua Kategori</option>
                <?php
                mysqli_data_seek($kategori_result, 0); // Reset pointer
                while ($kategori = mysqli_fetch_assoc($kategori_result)) :
                ?>
                  <option value="<?= $kategori['id'] ?>" <?= ($filter_kategori == $kategori['id']) ? 'selected' : '' ?> class="kategori-option">
                    <?= htmlspecialchars($kategori['nama']) ?>
                  </option>
                <?php endwhile; ?>
              </select>
            </div>
          </form>
        </div>
      </div>

      <!-- Products Grid -->
      <div class="row g-4" id="product-grid">
        <?php if (mysqli_num_rows($result) > 0): ?>
          <?php while ($row = mysqli_fetch_assoc($result)) : ?>
           <div class="col-6 col-sm-6 col-lg-4 col-xl-3 animate-on-scroll">
              <div class="card product-card h-100 border-0 shadow-sm">
                <div class="product-image-container">
                  <img src="upload/<?= htmlspecialchars($row['gambar']) ?>"
                    class="card-img-top product-image"
                    alt="<?= htmlspecialchars($row['nama']) ?>">
                  <div class="product-overlay">
                    <div class="product-actions">
                      <a href="detail_produk.php?id=<?= $row['id'] ?>"
                        class="btn btn-light btn-sm rounded-pill">
                        <i class="fas fa-eye me-2"></i>Lihat Detail
                      </a>
                    </div>
                  </div>
                </div>

                <div class="card-body p-4">
                  <div class="d-flex justify-content-between align-items-start mb-2">
                    <span class="badge bg-light text-dark small floating">
                      <?= htmlspecialchars($row['nama_kategori']) ?>
                    </span>
                    <i class="fas fa-heart text-muted heart-icon" data-bs-toggle="tooltip" title="Tambah ke Wishlist"></i>
                  </div>

                  <h5 class="card-title fw-bold text-dark mb-2">
                    <?= htmlspecialchars($row['nama']) ?>
                  </h5>
                  <?php if (!empty($row['diskon_id']) && isset($diskon_map[$row['diskon_id']])):
                    $diskon = $diskon_map[$row['diskon_id']];
                    $harga_diskon = $row['harga'] - ($row['harga'] * $diskon['persen'] / 100);
                  ?>
                    <span class="badge bg-danger mb-2">Diskon <?= $diskon['persen'] ?>% OFF</span><br>
                    <span class="text-muted text-decoration-line-through">Rp<?= number_format($row['harga'], 0, ',', '.') ?></span>
                    <span class="h5 fw-bold text-primary ms-2">Rp<?= number_format($harga_diskon, 0, ',', '.') ?></span>
                  <?php else: ?>
                    <span class="h5 fw-bold text-primary">Rp<?= number_format($row['harga'], 0, ',', '.') ?></span>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endwhile; ?>
        <?php else: ?>
          <div class="col-12">
            <div class="text-center py-5">
              <i class="fas fa-search fa-3x text-muted mb-3"></i>
              <h4 class="text-muted mb-2">Produk Tidak Ditemukan</h4>
              <p class="text-muted mb-4">Maaf, tidak ada produk yang sesuai dengan kategori yang dipilih.</p>
              <a href="?" class="btn btn-primary">
                <i class="fas fa-refresh me-2"></i>Lihat Semua Produk
              </a>
            </div>
          </div>
        <?php endif; ?>
      </div>

    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Custom Styles -->
  <style>
    /* Animation Keyframes */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    @keyframes fadeInLeft {
      from {
        opacity: 0;
        transform: translateX(-30px);
      }

      to {
        opacity: 1;
        transform: translateX(0);
      }
    }

    @keyframes fadeInRight {
      from {
        opacity: 0;
        transform: translateX(30px);
      }

      to {
        opacity: 1;
        transform: translateX(0);
      }
    }

    @keyframes bounceIn {
      0% {
        opacity: 0;
        transform: scale(0.3);
      }

      50% {
        opacity: 1;
        transform: scale(1.05);
      }

      70% {
        transform: scale(0.9);
      }

      100% {
        opacity: 1;
        transform: scale(1);
      }
    }

    @keyframes slideInDown {
      from {
        transform: translateY(-100%);
        opacity: 0;
      }

      to {
        transform: translateY(0);
        opacity: 1;
      }
    }

    /* Animation Classes */
    .fade-in-up {
      animation: fadeInUp 0.8s ease-out forwards;
    }

    .fade-in-left {
      animation: fadeInLeft 0.8s ease-out forwards;
    }

    .fade-in-right {
      animation: fadeInRight 0.8s ease-out forwards;
    }

    .bounce-in {
      animation: bounceIn 0.8s ease-out forwards;
    }

    .slide-in-down {
      animation: slideInDown 0.6s ease-out forwards;
    }

    /* Initial state for elements to be animated */
    .animate-on-scroll {
      opacity: 0;
      transform: translateY(30px);
      transition: all 0.6s ease-out;
      pointer-events: auto;
    }

    .animate-on-scroll.animated {
      opacity: 1;
      transform: translateY(0);
      pointer-events: auto;
    }

    /* Staggered animation delays */
    .product-card {
      opacity: 0;
      transform: translateY(30px);
      transition: all 0.6s ease-out;
      pointer-events: auto;
    }

    .product-card.animated {
      opacity: 1;
      transform: translateY(0);
      pointer-events: auto;
    }

    .product-card:nth-child(1) {
      transition-delay: 0.1s;
    }

    .product-card:nth-child(2) {
      transition-delay: 0.2s;
    }

    .product-card:nth-child(3) {
      transition-delay: 0.3s;
    }

    .product-card:nth-child(4) {
      transition-delay: 0.4s;
    }

    .product-card:nth-child(5) {
      transition-delay: 0.5s;
    }

    .product-card:nth-child(6) {
      transition-delay: 0.6s;
    }

    .product-card:nth-child(7) {
      transition-delay: 0.7s;
    }

    .product-card:nth-child(8) {
      transition-delay: 0.8s;
    }

    /* Hero Section */
    .hero-section {
      position: relative;
      height: 70vh;
      min-height: 500px;
    }

    .carousel-image-container {
      position: relative;
      height: 70vh;
      min-height: 500px;
      overflow: hidden;
    }

    .carousel-image-container img {
      height: 100%;
      object-fit: cover;
      object-position: center;
      transition: transform 8s ease-in-out;
    }

    /* Ken Burns effect for carousel images */
    .carousel-item.active .carousel-image-container img {
      transform: scale(1.1);
    }

    .carousel-overlay {
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
    }

    .carousel-caption {
      position: absolute;
      top: 50%;
      left: 0;
      right: 0;
      transform: translateY(-50%);
      text-align: left;
    }

    /* Enhanced hover effects */
    .product-card {
      transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
      cursor: pointer;
      border-radius: 18px;
      box-shadow: 0 4px 24px rgba(0, 0, 0, 0.07);
      border: none;
      background: #fff;
      overflow: hidden;
      position: relative;
      pointer-events: auto;
      z-index: 1;
    }

    .product-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
      opacity: 0;
      transition: opacity 0.4s ease;
      z-index: -1;
      pointer-events: none;
    }

    .product-card:hover::before {
      opacity: 1;
    }

    .product-card:hover {
      transform: translateY(-12px) scale(1.02);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15) !important;
      z-index: 10;
    }

    /* Make sure product card content is clickable */
    .product-card .card-body {
      position: relative;
      z-index: 2;
      pointer-events: auto;
    }

    .product-card .product-image-container {
      position: relative;
      z-index: 2;
      pointer-events: auto;
    }

    /* Ensure links are clickable */
    .product-card a,
    .product-card .btn {
      position: relative;
      z-index: 3;
      pointer-events: auto;
    }

    /* Loading animation */
    .loading-spinner {
      display: inline-block;
      width: 20px;
      height: 20px;
      border: 2px solid #f3f3f3;
      border-top: 2px solid #007bff;
      border-radius: 50%;
      animation: spin 1s linear infinite;
    }

    @keyframes spin {
      0% {
        transform: rotate(0deg);
      }

      100% {
        transform: rotate(360deg);
      }
    }

    /* Floating elements */
    .floating {
      animation: floating 3s ease-in-out infinite;
    }

    @keyframes floating {

      0%,
      100% {
        transform: translateY(0px);
      }

      50% {
        transform: translateY(-10px);
      }
    }

    /* Pulse effect for badges */
    .badge {
      animation: pulse 2s infinite;
    }

    @keyframes pulse {
      0% {
        transform: scale(1);
      }

      50% {
        transform: scale(1.05);
      }

      100% {
        transform: scale(1);
      }
    }

    /* Section Divider */
    .divider {
      width: 60px;
      height: 4px;
      background: linear-gradient(90deg, #007bff, #6610f2);
      border-radius: 2px;
      margin-top: 1rem;
    }

    /* Filter Kategori */
    .filter-card {
      display: none;
    }

    #filterForm label {
      font-weight: 600;
      color: #222;
    }

    #filterForm select {
      border-radius: 8px;
      font-size: 1em;
      padding: 8px 14px;
      border: 1.5px solid #e0e0e0;
      background: #f8f9fa;
      color: #222;
      font-weight: 500;
      transition: border-color 0.2s;
    }

    #filterForm select:focus {
      border-color: #34495e;
      box-shadow: 0 0 0 0.12rem rgba(52, 73, 94, 0.08);
    }

    .kategori-option {
      min-width: none;
      }
    .form-select{
      border-radius: 8px;
      font-size: 1em;
      padding: 8px 14px;
      border: 1.5px solid #e0e0e0;
      background: #f8f9fa;
      color: #222;
      font-weight: 500;
    }

    .product-image-container {
      position: relative;
      height: 230px;
      overflow: hidden;
      border-radius: 16px 16px 0 0;
      background: #f4f7f6;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .product-image {
      height: 100%;
      width: auto;
      max-width: 100%;
      object-fit: contain;
      transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
    }

    .product-card:hover .product-image {
      transform: scale(1.1) rotate(2deg);
    }

    .product-overlay {
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: linear-gradient(135deg, rgba(0, 0, 0, 0.7) 0%, rgba(0, 0, 0, 0.5) 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      opacity: 0;
      transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
      transform: scale(0.8);
      pointer-events: none;
      z-index: 5;
    }

    .product-card:hover .product-overlay {
      opacity: 1;
      transform: scale(1);
      pointer-events: auto;
    }

    .product-actions .btn {
      font-weight: 600;
      border-radius: 20px;
      padding: 8px 22px;
      font-size: 1em;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.07);
      background: #fff;
      color: #222;
      border: 1.5px solid #e0e0e0;
      transition: all 0.3s ease;
      transform: translateY(10px);
    }

    .product-card:hover .product-actions .btn {
      transform: translateY(0);
    }

    .product-actions .btn:hover {
      background: #34495e;
      color: #fff;
      border-color: #34495e;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(52, 73, 94, 0.3);
    }

    .badge.bg-light.text-dark.small {
      background: #f4f7f6 !important;
      color: #222 !important;
      font-weight: 600;
      border-radius: 8px;
      padding: 6px 14px;
      font-size: 0.95em;
    }

    .badge.bg-danger.mb-2 {
      background: linear-gradient(90deg, #e74c3c, #f39c12) !important;
      color: #fff !important;
      font-weight: 600;
      border-radius: 8px;
      padding: 6px 14px;
      font-size: 0.95em;
      letter-spacing: 0.5px;
    }

    .h5.fw-bold.text-primary,
    .h5.fw-bold.text-primary.ms-2 {
      color: #34495e !important;
      font-weight: 700;
      font-size: 1.2em;
    }

    .text-muted.text-decoration-line-through {
      font-size: 1em;
      color: #b0b0b0 !important;
    }

    .heart-icon {
      cursor: pointer;
      transition: color 0.3s ease;
      font-size: 1.2em;
    }

    .heart-icon:hover {
      color: #dc3545 !important;
    }

    .card-title {
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }
    
    .poster-img {
      width: 100vw;
      max-width: 100vw;
      height: auto;
      object-fit: contain;
      background: #fff;
      display: block;
      margin: 0 auto;
    }

    @media (max-width: 768px) {

      .hero-section,
      .carousel-image-container {
        height: 50vh;
        min-height: 400px;
      }

      .carousel-caption h1 {
        font-size: 2rem;
      }

      .carousel-caption p {
        font-size: 1rem;
      }

      .product-image-container {
        height: 160px;
      }

      .product-card {
        border-radius: 12px;
      }
    }

    /* Untuk mobile: atur agar responsif dan tidak collapse */
    @media (max-width: 600px) {
      .carousel-image-container {
        min-height: 160px;
        height: auto !important;
        display: flex;
        align-items: center;
        justify-content: center;
        background: #fff;
        padding: 0;
        margin-bottom: 0 !important;
      }
      .poster-img {
        width: 100vw;
        max-width: 100vw;
        height: auto;
        object-fit: contain;
        background: #fff;
        display: block;
        margin: 0 auto;
      }
      .carousel,
      .carousel-inner,
      .carousel-item,
      .hero-section,
      #heroCarousel {
        margin-bottom: 0 !important;
        padding-bottom: 0 !important;
        height: auto !important;
        min-height: unset !important;
        max-height: none !important;
      }
    }
    
    @media (max-width: 1900px) {
      .carousel-image-container {
        min-height: 160px;
        height: auto !important;
        display: flex;
        align-items: center;
        justify-content: center;
        background: #fff;
        padding: 0;
        margin-bottom: 0 !important;
      }
      .poster-img {
        width: 100vw;
        max-width: 100vw;
        height: auto;
        object-fit: contain;
        background: #fff;
        display: block;
        margin: 0 auto;
      }
      .carousel,
      .carousel-inner,
      .carousel-item,
      .hero-section,
      #heroCarousel {
        margin-bottom: 0 !important;
        padding-bottom: 0 !important;
        height: auto !important;
        min-height: unset !important;
        max-height: none !important;
      }
    }
    @media (max-width: 430px){
      .card-body{
        width: 160px;
      }
    }
    /* Untuk layar besar, tampilkan teks penuh */
    @media (min-width: 576px) {
      .card-title {
        white-space: normal;
        overflow: visible;
        text-overflow: unset;
      }
    }
  </style>

  <!-- Custom JavaScript -->
  <script>
    // Initialize page animations
    document.addEventListener('DOMContentLoaded', function() {
      initializeAnimations();
      setupScrollAnimations();
      setupProductAnimations();
    });

    // Initialize tooltips and basic animations
    function initializeAnimations() {
      // Initialize Bootstrap tooltips
      var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
      var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
      });

      // Add slide-in animation to navbar
      setTimeout(() => {
        const navbar = document.querySelector('.navbar');
        if (navbar) {
          navbar.classList.add('slide-in-down');
        }
      }, 100);
    }

    // Setup scroll-triggered animations
    function setupScrollAnimations() {
      const animateElements = document.querySelectorAll('.animate-on-scroll');

      const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
      };

      const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            entry.target.classList.add('animated');
            observer.unobserve(entry.target);
          }
        });
      }, observerOptions);

      animateElements.forEach(element => {
        observer.observe(element);
      });
    }

    // Setup staggered product card animations and click handlers
    function setupProductAnimations() {
      const productCards = document.querySelectorAll('.product-card');

      const cardObserver = new IntersectionObserver((entries) => {
        entries.forEach((entry, index) => {
          if (entry.isIntersecting) {
            setTimeout(() => {
              entry.target.classList.add('animated');
            }, index * 100); // Stagger the animations
            cardObserver.unobserve(entry.target);
          }
        });
      }, {
        threshold: 0.1,
        rootMargin: '0px 0px -30px 0px'
      });

      productCards.forEach(card => {
        cardObserver.observe(card);

        // Make entire card clickable
        card.addEventListener('click', function(e) {
          // Don't trigger if clicking on the overlay button
          if (!e.target.closest('.product-actions')) {
            const detailLink = this.querySelector('.product-actions a');
            if (detailLink) {
              window.location.href = detailLink.href;
            }
          }
        });

        // Add pointer cursor
        card.style.cursor = 'pointer';
      });
    }

    // Smooth scroll to products section
    document.querySelectorAll('a[href="#products"]').forEach(anchor => {
      anchor.addEventListener('click', function(e) {
        e.preventDefault();
        document.querySelector('#products').scrollIntoView({
          behavior: 'smooth'
        });
      });
    });

    // Enhanced form handling with loading animation
    document.getElementById('filterForm').addEventListener('submit', function() {
      const select = this.querySelector('select');
      const originalHTML = select.innerHTML;
      select.innerHTML = '<option><span class="loading-spinner"></span> Memuat...</option>';
      select.disabled = true;

      // Add loading class to products with staggered fade out
      const productCards = document.querySelectorAll('.product-card');
      productCards.forEach((card, index) => {
        setTimeout(() => {
          card.style.opacity = '0.3';
          card.style.transform = 'translateY(10px)';
        }, index * 50);
      });
    });

    // Enhanced wishlist functionality with animations
    document.querySelectorAll('.heart-icon').forEach(icon => {
      icon.addEventListener('click', function(e) {
        e.preventDefault();
        e.stopPropagation();

        this.classList.toggle('text-danger');
        this.classList.toggle('text-muted');

        // Add bounce animation
        this.style.transform = 'scale(1.3)';
        setTimeout(() => {
          this.style.transform = 'scale(1)';
        }, 200);

        // Show floating notification
        const isAdded = this.classList.contains('text-danger');
        showFloatingNotification(
          isAdded ? 'Ditambahkan ke wishlist!' : 'Dihapus dari wishlist!',
          isAdded ? 'success' : 'info'
        );
      });
    });

    // Floating notification function
    function showFloatingNotification(message, type = 'success') {
      const notification = document.createElement('div');
      notification.className = `alert alert-${type} position-fixed`;
      notification.style.cssText = `
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 250px;
        opacity: 0;
        transform: translateX(100%);
        transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        border: none;
        border-radius: 12px;
      `;
      notification.innerHTML = `
        <div class="d-flex align-items-center">
          <i class="fas fa-${type === 'success' ? 'check' : 'info'}-circle me-2"></i>
          ${message}
        </div>
      `;

      document.body.appendChild(notification);

      // Animate in
      setTimeout(() => {
        notification.style.opacity = '1';
        notification.style.transform = 'translateX(0)';
      }, 100);

      // Animate out and remove
      setTimeout(() => {
        notification.style.opacity = '0';
        notification.style.transform = 'translateX(100%)';
        setTimeout(() => {
          notification.remove();
        }, 300);
      }, 3000);
    }

    // Enhanced lazy loading with fade effect
    const imageObserver = new IntersectionObserver((entries, observer) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          const img = entry.target;
          img.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
          img.style.opacity = '1';
          img.style.transform = 'scale(1)';
          observer.unobserve(img);
        }
      });
    });

    document.querySelectorAll('.product-image').forEach(img => {
      img.style.opacity = '0';
      img.style.transform = 'scale(0.95)';
      img.addEventListener('load', () => {
        img.style.opacity = '1';
        img.style.transform = 'scale(1)';
      });
      imageObserver.observe(img);
    });

    document.addEventListener("DOMContentLoaded", function () {
    const isMobile = window.innerWidth < 576;
  });
  </script>
  <?php include 'footer.php'; ?>
</body>

</html>