<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Tentukan path config.php berdasarkan lokasi file yang memanggil
$config_paths = [
    '../config.php',      // untuk file di admin/
    '../../config.php',   // untuk file di admin/subfolder/
    '../../../config.php' // untuk file di admin/subfolder/subfolder/
];

foreach ($config_paths as $path) {
    if (file_exists($path)) {
        require_once $path;
        break;
    }
}

// Tentukan path admin_helper.php
$helper_paths = [
    'admin_helper.php',      // untuk file di admin/
    '../admin_helper.php',   // untuk file di admin/subfolder/
    '../../admin_helper.php' // untuk file di admin/subfolder/subfolder/
];

foreach ($helper_paths as $path) {
    if (file_exists($path)) {
        require_once $path;
        break;
    }
}

// Dapatkan nama file saat ini untuk cek akses
$current_page = basename($_SERVER['PHP_SELF']);
checkAdminAccess($current_page);

// Dapatkan info admin jika login diperlukan
$admin_info = null;
$protected_pages = ['dashboard.php', 'profile.php'];
$requires_login = false;
foreach ($protected_pages as $page) {
    if (strpos($current_page, $page) !== false) {
        $requires_login = true;
        $admin_info = getAdminInfo();
        break;
    }
}
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Panel - Day Apparel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            background-color: #f4f7f6;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .sidebar {
            width: 260px;
            background-color: #ffffff;
            box-shadow: 2px 0 15px rgba(0, 0, 0, 0.05);
            padding-top: 20px;
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }

        .content {
            margin-left: 260px;
            padding: 30px;
            background-color: #f4f7f6;
            min-height: 100vh;
        }

        /* Sidebar Styling */
        .sidebar .sidebar-header {
            text-align: center;
            padding: 15px 20px;
            margin-bottom: 20px;
            border-bottom: 1px solid #eee;
            /* Light separator */
        }

        .sidebar .sidebar-header h4 {
            color: #34495e;
            /* Dark blue/gray for the header title */
            font-weight: 700;
            /* Bold */
            font-size: 1.6rem;
            margin-bottom: 5px;
        }

        .sidebar .sidebar-header span {
            display: block;
            font-size: 0.85rem;
            color: #888;
        }

        .sidebar .nav-link {
            color: #555;
            /* Muted text color for links */
            text-decoration: none;
            padding: 12px 25px;
            /* More padding for a spacious feel */
            display: flex;
            /* Use flex for icon and text alignment */
            align-items: center;
            border-radius: 8px;
            /* Slightly rounded corners for links */
            margin: 5px 15px;
            /* Vertical and horizontal margin for spacing */
            transition: all 0.2s ease-in-out;
            /* Smooth transitions */
            font-weight: 500;
            /* Medium font weight */
            font-size: 1.02rem;
        }

        .sidebar .nav-link i {
            margin-right: 12px;
            /* Space between icon and text */
            font-size: 1.1rem;
            color: #777;
            /* Muted icon color */
            transition: color 0.2s ease-in-out;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            /* Active state styling */
            background-color: #e9ecef;
            /* Light gray background on hover/active */
            color: #34495e;
            /* Darker text on hover/active */
        }

        .sidebar .nav-link:hover i,
        .sidebar .nav-link.active i {
            color: #34495e;
            /* Darker icon on hover/active */
        }

        /* Active link indicator (optional, but nice) */
        .sidebar .nav-link.active {
            position: relative;
        }

        .sidebar .nav-link.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 80%;
            /* Adjust height to fill most of the link */
            background-color: #34495e;
            /* Primary color indicator */
            border-radius: 2px;
        }

        .sidebar .logout-link {
            margin-top: auto;
            /* Pushes logout link to the bottom */
            margin-bottom: 20px;
            /* Space from bottom */
            border-top: 1px solid #eee;
            /* Separator above logout */
            padding-top: 15px;
        }

        /* Main Content Area */
        /* Responsive Adjustments */
        @media (max-width: 991.98px) {
            .sidebar {
                position: static;
                width: 100%;
                min-height: auto;
                height: auto;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
                padding-bottom: 10px;
                border-bottom: 1px solid #eee;
            }

            .sidebar .sidebar-header {
                border-bottom: none;
                /* Remove bottom border on mobile header */
                margin-bottom: 0;
                padding-bottom: 0;
            }

            .sidebar .nav-link {
                margin: 5px 10px;
                /* Adjust link margin for mobile */
            }

            .sidebar .logout-link {
                margin-top: 10px;
                /* Less margin on mobile */
                border-top: none;
                /* No top border on mobile logout */
                padding-top: 0;
            }

            .content {
                margin-left: 0;
                padding: 15px;
            }
        }
    </style>
</head>

<body>

    <?php
    // Pastikan tidak ada output sebelum tag PHP ini!
    $current_page = basename(
        $_SERVER['PHP_SELF']
    );
    $current_dir = basename(dirname($_SERVER['PHP_SELF']));
    $full_path = $current_dir . '/' . $current_page;
    $menu_items = [
        ['name' => 'Dashboard', 'path' => 'dashboard.php', 'icon' => 'fas fa-chart-line'],
        ['name' => 'Produk', 'path' => 'produk/daftar_produk.php', 'icon' => 'fas fa-box'],
        ['name' => 'Cek Pesanan', 'path' => 'cek_pesanan.php', 'icon' => 'fas fa-shopping-cart'],
        ['name' => 'Kategori', 'path' => 'kategori/daftar_kategori.php', 'icon' => 'fas fa-tags'],
        ['name' => 'Diskon', 'path' => 'diskon/daftar_diskon.php', 'icon' => 'fas fa-percent'],
        ['name' => 'Data Pelanggan', 'path' => 'data_pelanggan.php', 'icon' => 'fas fa-users'],
        ['name' => 'Profil', 'path' => 'profile.php', 'icon' => 'fas fa-user-circle'],
        ['name' => 'Kelola Ulasan', 'path' => 'ulasan/index.php', 'icon' => 'fas fa-star'],
    ];
    ?>
    <div class="sidebar">
        <div class="sidebar-header">
            <h4>Admin Panel</h4>
            <span>Day Apparel Management</span>
        </div>
        <nav class="nav flex-column">
            <?php
            foreach ($menu_items as $item) {
                $is_active = ($full_path === $item['path']) || ($current_page === $item['path']);
                $active_class = $is_active ? ' active' : '';
                echo '<a href="/day.apparel/admin/' . htmlspecialchars($item['path']) . '" class="nav-link' . $active_class . '">';
                echo '<i class="' . htmlspecialchars($item['icon']) . '"></i>' . htmlspecialchars($item['name']);
                echo '</a>';
            }
            ?>
        </nav>
        <div class="logout-link">
            <a href="/day.apparel/login/admin_login.php" onclick="return confirm('Yakin ingin logout?')" class="nav-link text-danger">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>
    </div>
    <div class="content">

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>