<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

include '../../config.php';
include '../sidebar.php'; // Ensure this path is correct based on your file structure

// --- PHP Logic Enhancements ---

// Fetch all category data (kategori_produk)
// Using prepared statement for better security and consistency
$stmt_kategori = $conn->prepare("SELECT * FROM kategori_produk ORDER BY nama ASC");
if ($stmt_kategori === false) {
    die("Prepare failed for kategori query: " . $conn->error);
}
$stmt_kategori->execute();
$result_kategori = $stmt_kategori->get_result();

// Initialize $modalEdit array to store modal HTML for editing
$modalEdit = [];
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Kategori Produk - Admin Day Apparel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f7f6;
            /* Light gray background */
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }

        /* Content wrapper styles from previous pages */
        #page-content-wrapper {
            flex-grow: 1;
            padding: 30px;
            background-color: #ffffff;
            /* White content background */
            border-radius: 12px;
            /* Softly rounded corners */
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
            /* Subtle shadow */
            margin: 20px;
            /* Margin around the content area */
        }

        .main-header {
            font-size: 2.2rem;
            font-weight: 700;
            color: #2c3e50;
            /* Darker title color */
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #eee;
            /* Subtle separator */
            text-align: center;
        }

        /* Button Styling */
        .btn-primary {
            background-color: #34495e;
            /* Darker blue/gray primary */
            border-color: #34495e;
            transition: all 0.3s ease;
            font-weight: 600;
            padding: 10px 20px;
            border-radius: 8px;
            /* Rounded buttons */
        }

        .btn-primary:hover {
            background-color: #2c3e50;
            border-color: #2c3e50;
            transform: translateY(-2px);
            /* Slight lift on hover */
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .btn-warning {
            background-color: #f39c12;
            /* Flat orange */
            border-color: #f39c12;
            color: #fff;
            font-weight: 500;
            border-radius: 6px;
        }

        .btn-warning:hover {
            background-color: #e67e22;
            border-color: #e67e22;
            color: #fff;
        }

        .btn-danger {
            background-color: #e74c3c;
            /* Flat red */
            border-color: #e74c3c;
            font-weight: 500;
            border-radius: 6px;
        }

        .btn-danger:hover {
            background-color: #c0392b;
            border-color: #c0392b;
        }

        .btn-secondary {
            background-color: #bdc3c7;
            /* Light gray for secondary actions */
            border-color: #bdc3c7;
            color: #fff;
            font-weight: 500;
            border-radius: 6px;
        }

        .btn-secondary:hover {
            background-color: #95a5a6;
            border-color: #95a5a6;
            color: #fff;
        }

        /* Table Styling */
        .table {
            background-color: #fff;
            border-radius: 10px;
            /* Rounded table corners */
            overflow: hidden;
            /* Ensures radius applies */
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.03);
            /* Very light table shadow */
            margin-top: 20px;
        }

        .table thead th {
            background-color: #ecf0f1;
            /* Light header background */
            color: #555;
            font-weight: 600;
            border-bottom: 1px solid #dee2e6;
            padding: 12px 15px;
            text-transform: uppercase;
            font-size: 0.9em;
        }

        .table tbody tr:hover {
            background-color: #f9f9f9;
            /* Subtle hover effect */
        }

        .table td {
            padding: 12px 15px;
            vertical-align: middle;
            font-size: 0.95em;
        }

        /* Alert Styling */
        .alert {
            border-radius: 8px;
            /* Rounded alert corners */
            font-size: 1.05em;
            padding: 15px 20px;
            margin-bottom: 25px;
            /* Space below alert */
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border-color: #c3e6cb;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border-color: #f5c6cb;
        }

        .alert-warning {
            background-color: #fff3cd;
            color: #856404;
            border-color: #ffeeba;
        }

        .alert .btn-close {
            font-size: 0.9em;
        }

        /* Modal Styling */
        .modal-content {
            border-radius: 12px;
            /* Rounded modal corners */
            border: none;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
        }

        .modal-header {
            background-color: #f8f9fa;
            /* Light header */
            border-bottom: 1px solid #e9ecef;
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
            padding: 20px;
        }

        .modal-header h5 {
            color: #34495e;
            /* Dark title */
            font-weight: 600;
            font-size: 1.5rem;
        }

        .modal-body {
            padding: 25px;
        }

        .modal-footer {
            border-top: 1px solid #e9ecef;
            padding: 15px 25px;
            border-bottom-left-radius: 12px;
            border-bottom-right-radius: 12px;
        }

        .form-control {
            border-radius: 8px;
            /* Rounded input fields */
            padding: 10px 15px;
            border: 1px solid #ddd;
            transition: border-color 0.2s ease;
        }

        .form-control:focus {
            border-color: #34495e;
            /* Highlight border on focus */
            box-shadow: 0 0 0 0.25rem rgba(52, 73, 94, 0.25);
        }

        label {
            font-weight: 500;
            color: #555;
            margin-bottom: 5px;
            display: block;
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php // The sidebar.php content is included here 
        ?>
        <div id="page-content-wrapper">
            <div class="container-fluid">
                <h3 class="main-header">Data Kategori Produk</h3>

                <?php if (isset($_SESSION['alert'])): ?>
                    <div class="alert alert-<?= $_SESSION['alert']['type'] ?> alert-dismissible fade show" role="alert">
                        <i class="fas fa-info-circle me-2"></i> <?= $_SESSION['alert']['message'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php unset($_SESSION['alert']); ?>
                <?php endif; ?>

                <button class="btn btn-primary mb-4" data-bs-toggle="modal" data-bs-target="#modalTambahKategori">
                    <i class="fas fa-plus-circle me-2"></i> Tambah Kategori Baru
                </button>

                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Nama Kategori</th>
                                <th class="text-center">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($result_kategori->num_rows > 0): ?>
                                <?php while ($row = $result_kategori->fetch_assoc()) : ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['nama']) ?></td>
                                        <td class="text-center">
                                            <button class="btn btn-warning btn-sm me-2" data-bs-toggle="modal" data-bs-target="#modalEditKategori<?= $row['id'] ?>" title="Edit Kategori">
                                                <i class="fas fa-edit"></i> Edit
                                            </button>
                                            <a href="hapus_kategori.php?id=<?= htmlspecialchars($row['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus kategori ini?')" title="Hapus Kategori">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                            </a>
                                        </td>
                                    </tr>
                                    <?php
                                    // Store modal HTML in the array
                                    $modalEdit[] = '
                                    <div class="modal fade" id="modalEditKategori' . $row['id'] . '" tabindex="-1" aria-labelledby="modalEditKategoriLabel' . $row['id'] . '" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="edit_kategori.php" method="POST" class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="modalEditKategoriLabel' . $row['id'] . '">Edit Kategori: ' . htmlspecialchars($row['nama']) . '</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="' . htmlspecialchars($row['id']) . '">
                                                    <div class="mb-3">
                                                        <label for="nama_edit' . $row['id'] . '" class="form-label">Nama Kategori</label>
                                                        <input type="text" name="nama" id="nama_edit' . $row['id'] . '" class="form-control" value="' . htmlspecialchars($row['nama']) . '" required>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Batal</button>
                                                    <button class="btn btn-primary" type="submit"><i class="fas fa-save me-2"></i>Simpan Perubahan</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>';
                                    ?>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="2" class="text-center py-4 text-muted">Tidak ada data kategori produk yang ditemukan.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php
    if (!empty($modalEdit)) {
        foreach ($modalEdit as $modal) {
            echo $modal;
        }
    }
    ?>

    <div class="modal fade" id="modalTambahKategori" tabindex="-1" aria-labelledby="modalTambahKategoriLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form action="tambah_kategori.php" method="post" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTambahKategoriLabel">Tambah Kategori Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nama_add" class="form-label">Nama Kategori</label>
                        <input type="text" name="nama" id="nama_add" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Batal</button>
                    <button class="btn btn-primary" type="submit"><i class="fas fa-plus me-2"></i>Tambah Kategori</button>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>