<?php
require '../config.php';
require '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

if (session_status() == PHP_SESSION_NONE) {
  session_start();
}

$transaksi_id = (int)$_GET['id'] ?? 0;

// Ambil data transaksi
$transaksi = mysqli_fetch_assoc(mysqli_query($conn, "
  SELECT t.*, p.nama AS nama_pelanggan, p.alamat_lengkap 
  FROM transaksi t 
  JOIN pengguna p ON t.pengguna_id = p.id 
  WHERE t.id = $transaksi_id
"));

// Ambil data detail pesanan
$detail = mysqli_query($conn, "
  SELECT td.*, pr.nama, up.ukuran
  FROM transaksi_detail td 
  JOIN produk pr ON td.produk_id = pr.id 
  JOIN ukuran_produk up ON td.ukuran_id = up.id
  WHERE td.transaksi_id = $transaksi_id
");
function formatKodeTransaksi($id, $timestamp)
{
  $tanggal = date('Ymd', strtotime($timestamp));
  return 'TRX-' . $tanggal . '-' . str_pad($id, 4, '0', STR_PAD_LEFT);
}

ob_start();
?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <style>
    body {
      font-family: 'Helvetica', 'Arial', sans-serif;
      font-size: 12px;
      color: #333;
      margin: 40px;
    }

    .brand {
      text-align: center;
      margin-bottom: 20px;
    }

    .brand img {
      height: 50px;
    }

    .brand h1 {
      font-size: 20px;
      margin: 5px 0 0 0;
      letter-spacing: 1px;
    }

    .info,
    .footer {
      margin-bottom: 20px;
    }

    .info p {
      margin: 2px 0;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }

    thead {
      background-color: #f5f5f5;
    }

    th,
    td {
      padding: 8px 10px;
      text-align: left;
      border-bottom: 1px solid #ddd;
    }

    .total td {
      font-weight: bold;
      background: #f9f9f9;
    }

    .footer {
      text-align: center;
      font-size: 11px;
      color: #777;
      margin-top: 40px;
    }
  </style>
</head>

<body>

  <div class="brand">
    <img src="http://localhost/day.apparel/assets/day.apparel.jpeg" alt="Logo Brand">
    <h1>Day.APPAREL</h1>
  </div>

  <h2 style="text-align:center; margin-top:0;">Invoice Pemesanan</h2>

  <div class="info">
    <p><strong>No. Transaksi:</strong> <?= formatKodeTransaksi($transaksi['id'], $transaksi['dibuat_pada']) ?></p>
    <p><strong>Tanggal:</strong> <?= date('d M Y H:i', strtotime($transaksi['dibuat_pada'])) ?></p>
    <p><strong>Nama:</strong> <?= htmlspecialchars($transaksi['nama_pelanggan']) ?></p>
    <p><strong>Alamat:</strong> <?= htmlspecialchars($transaksi['alamat_lengkap']) ?></p>
    <p><strong>Status:</strong> <?= ucfirst($transaksi['status']) ?></p>
    <?php if (!empty($transaksi['resi'])) : ?>
      <p><strong>Resi Pengiriman:</strong> <?= htmlspecialchars($transaksi['resi']) ?></p>
    <?php endif; ?>
  </div>

  <table>
    <thead>
      <tr>
        <th>Produk</th>
        <th>Ukuran</th>
        <th>Jumlah</th>
        <th>Subtotal</th>
      </tr>
    </thead>
    <tbody>
      <?php $total = 0;
      while ($row = mysqli_fetch_assoc($detail)) : ?>
        <tr>
          <td><?= htmlspecialchars($row['nama']) ?></td>
          <td><?= htmlspecialchars($row['ukuran']) ?></td>
          <td><?= $row['jumlah'] ?></td>
          <td>Rp <?= number_format($row['subtotal'], 0, ',', '.') ?></td>
        </tr>
        <?php $total += $row['subtotal']; ?>
      <?php endwhile; ?>
      <tr class="total">
        <td colspan="3" style="text-align:right;">Ongkir</td>
        <td>Rp <?= number_format($transaksi['ongkos_kirim'], 0, ',', '.') ?></td>
      </tr>
      <tr class="total">
        <td colspan="3" style="text-align:right;">Total</td>
        <td>Rp <?= number_format($transaksi['total_harga'], 0, ',', '.') ?></td>
      </tr>
    </tbody>
  </table>

  <div class="footer">
    Terima kasih telah berbelanja di <strong>Day.Apparel</strong>.
  </div>

</body>

</html>

<?php
$html = ob_get_clean();

// Setup Dompdf
$options = new Options();
$options->set('isRemoteEnabled', true); // Untuk memuat logo dari URL
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("invoice_{$transaksi_id}.pdf", ["Attachment" => false]);
exit;
